unit dotNetAppForm;

interface

uses
  System.Runtime.InteropServices,
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  frmPInvoke = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnHResult: System.Windows.Forms.Button;
    btnNoHResult: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnNoHResult_Click(sender: System.Object; e: System.EventArgs);
    procedure btnHResult_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(frmPInvoke))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure frmPInvoke.InitializeComponent;
begin
  Self.btnHResult := System.Windows.Forms.Button.Create;
  Self.btnNoHResult := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // btnHResult
  // 
  Self.btnHResult.Location := System.Drawing.Point.Create(73, 23);
  Self.btnHResult.Name := 'btnHResult';
  Self.btnHResult.Size := System.Drawing.Size.Create(240, 23);
  Self.btnHResult.TabIndex := 0;
  Self.btnHResult.Text := 'HResult';
  Include(Self.btnHResult.Click, Self.btnHResult_Click);
  // 
  // btnNoHResult
  // 
  Self.btnNoHResult.Location := System.Drawing.Point.Create(73, 61);
  Self.btnNoHResult.Name := 'btnNoHResult';
  Self.btnNoHResult.Size := System.Drawing.Size.Create(240, 23);
  Self.btnNoHResult.TabIndex := 1;
  Self.btnNoHResult.Text := 'No HResult';
  Include(Self.btnNoHResult.Click, Self.btnNoHResult_Click);
  // 
  // frmPInvoke
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(402, 106);
  Self.Controls.Add(Self.btnNoHResult);
  Self.Controls.Add(Self.btnHResult);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'frmPInvoke';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := '.NET App Using Win32 COM Routines';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure frmPInvoke.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor frmPInvoke.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

const
  ole32  = 'ole32.dll';

{.$define USE_PARAMETER_ATTRIBUTES}

{$ifdef USE_PARAMETER_ATTRIBUTES}

function CLSIDFromProgID1([MarshalAs(UnmanagedType.LPWStr)] ppsz: String;
  out rclsid: Guid): Integer; stdcall; external ole32 name 'CLSIDFromProgID';
[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', PreserveSig = False)]
procedure CLSIDFromProgID2([MarshalAs(UnmanagedType.LPWStr)] ppsz: String;
  out rclsid: Guid); external;

{$else}

[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', CharSet = CharSet.Unicode)]
function CLSIDFromProgID1(ppsz: String; out rclsid: Guid): Integer; external;
[DllImport(ole32, EntryPoint = 'CLSIDFromProgID', CharSet = CharSet.Unicode, PreserveSig = False)]
procedure CLSIDFromProgID2(ppsz: String; out rclsid: Guid); external;

{$endif}

const
  OKProgID = 'Word.Application';
  BadProgID = 'Foo.Bar';

function ProgIDToGUID1(const ProgID: String): String;
var
  AGuid: Guid;
  Res: Integer;
begin
  AGuid := Guid.Empty;
  Res := CLSIDFromProgID1(ProgID, AGuid);
  if Res >= 0 then
    Result := AGuid.ToString
  else
    raise Exception.Create(System.String.Format('Error ${0:X}', [Res]))
end;

function ProgIDToGUID2(const ProgID: String): String;
var
  AGuid: Guid;
begin
  AGuid := Guid.Empty;
  CLSIDFromProgID2(ProgID, AGuid);
  Result := AGuid.ToString
end;

procedure frmPInvoke.btnHResult_Click(sender: System.Object; e: System.EventArgs);
begin
  MessageBox.Show(System.String.Format(
    'GUID for {0} is {1}', [OKProgID, ProgIDToGUID1(OKProgID)]));
  MessageBox.Show(System.String.Format(
    'GUID for {0} is {1}', [BadProgID, ProgIDToGUID1(BadProgID)]));
end;

procedure frmPInvoke.btnNoHResult_Click(sender: System.Object; e: System.EventArgs);
begin
  MessageBox.Show(System.String.Format(
    'GUID for {0} is {1}', [OKProgID, ProgIDToGUID2(OKProgID)]));
  MessageBox.Show(System.String.Format(
    'GUID for {0} is {1}', [BadProgID, ProgIDToGUID2(BadProgID)]));
end;

end.
